package gov.va.vinci.dart.db.impl;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.DataSourceDisplayHeader;
import gov.va.vinci.dart.db.DataSourceDisplayHeaderDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

import java.util.List;

import javax.persistence.Query;

public class DataSourceDisplayHeaderDAOImpl extends HibernateDAO implements DataSourceDisplayHeaderDAO {

	@Override
	public DataSourceDisplayHeader findById(final int displayHeaderId) throws ObjectNotFoundException {
		Query q = createQuery("from DataSourceDisplayHeader where id=:hid");
		q.setParameter("hid", displayHeaderId);
		return (DataSourceDisplayHeader)q.getSingleResult();
	}


	@Override
	@SuppressWarnings("unchecked")
	public List<DataSourceDisplayHeader> listAll() {
		Query query = createQuery("from DataSourceDisplayHeader");
		return (List<DataSourceDisplayHeader>)query.getResultList();
	}

	
	@Override
	@SuppressWarnings("unchecked")
	public List<DataSourceDisplayHeader> listAllByRequestType(final int requestTypeId) {
		Query query = createQuery("from DataSourceDisplayHeader where requestTypeId=:rtid");
		query.setParameter("rtid", requestTypeId);
		
		return (List<DataSourceDisplayHeader>)query.getResultList();
	}
}
